/*
 * Decompiled with CFR 0.152.
 */
package net.craftminecraft.bungee.bungeeyaml.supereasyconfig;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.craftminecraft.bungee.bungeeyaml.bukkitapi.ConfigurationSection;
import net.craftminecraft.bungee.bungeeyaml.bukkitapi.InvalidConfigurationException;
import net.craftminecraft.bungee.bungeeyaml.supereasyconfig.Comment;
import net.craftminecraft.bungee.bungeeyaml.supereasyconfig.Path;

public abstract class ConfigObject {
    protected void onLoad(ConfigurationSection cs) throws Exception {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String path = field.getName().replaceAll("_", ".");
            if (field.getAnnotation(Path.class) != null) {
                path = field.getAnnotation(Path.class).value();
            }
            if (!this.doSkip(field)) {
                if (cs.isSet(path)) {
                    field.set(this, this.loadObject(field, cs, path));
                } else {
                    cs.set(path, this.saveObject(field.get(this), field, cs, path));
                }
            }
            ++n2;
        }
    }

    protected void onSave(ConfigurationSection cs) throws Exception {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String path = field.getName().replaceAll("_", ".");
            if (field.getAnnotation(Path.class) != null) {
                path = field.getAnnotation(Path.class).value();
            }
            if (!this.doSkip(field)) {
                cs.set(path, this.saveObject(field.get(this), field, cs, path));
                if (field.getAnnotation(Comment.class) != null) {
                    cs.setComment(path, field.getAnnotation(Comment.class).value());
                }
            }
            ++n2;
        }
    }

    protected Object loadObject(Field field, ConfigurationSection cs, String path) throws Exception {
        return this.loadObject(field, cs, path, 0);
    }

    protected Object saveObject(Object obj, Field field, ConfigurationSection cs, String path) throws Exception {
        return this.saveObject(obj, field, cs, path, 0);
    }

    protected Object loadObject(Field field, ConfigurationSection cs, String path, int depth) throws Exception {
        Class clazz = this.getClassAtDepth(field.getGenericType(), depth);
        if (ConfigObject.class.isAssignableFrom(clazz) && this.isConfigurationSection(cs.get(path))) {
            return this.getConfigObject(clazz, cs.getConfigurationSection(path));
        }
        if (Multimap.class.isAssignableFrom(clazz) && this.isConfigurationSection(cs.get(path))) {
            return this.getMultimap(field, cs.getConfigurationSection(path), path, depth);
        }
        if (Table.class.isAssignableFrom(clazz) && this.isConfigurationSection(cs.get(path))) {
            return this.getTable(field, cs.getConfigurationSection(path), path, depth);
        }
        if (Map.class.isAssignableFrom(clazz) && this.isConfigurationSection(cs.get(path))) {
            return this.getMap(field, cs.getConfigurationSection(path), path, depth);
        }
        if (clazz.isEnum() && this.isString(cs.get(path))) {
            return this.getEnum(clazz, (String)cs.get(path));
        }
        if (List.class.isAssignableFrom(clazz) && this.isConfigurationSection(cs.get(path))) {
            Class subClazz = this.getClassAtDepth(field.getGenericType(), depth + 1);
            if (ConfigObject.class.isAssignableFrom(subClazz) || Map.class.isAssignableFrom(subClazz) || List.class.isAssignableFrom(subClazz) || subClazz.isEnum()) {
                return this.getList(field, cs.getConfigurationSection(path), path, depth);
            }
            return cs.get(path);
        }
        return cs.get(path);
    }

    protected Object saveObject(Object obj, Field field, ConfigurationSection cs, String path, int depth) throws Exception {
        Class clazz = this.getClassAtDepth(field.getGenericType(), depth);
        if (ConfigObject.class.isAssignableFrom(clazz) && this.isConfigObject(obj)) {
            return this.getConfigObject((ConfigObject)obj, path, cs);
        }
        if (Multimap.class.isAssignableFrom(clazz) && this.isMultimap(obj)) {
            return this.getMultimap((Multimap)obj, field, cs, path, depth);
        }
        if (Table.class.isAssignableFrom(clazz) && this.isTable(obj)) {
            return this.getTable((Table)obj, field, cs, path, depth);
        }
        if (Map.class.isAssignableFrom(clazz) && this.isMap(obj)) {
            return this.getMap((Map)obj, field, cs, path, depth);
        }
        if (clazz.isEnum() && this.isEnum(clazz, obj)) {
            return this.getEnum((Enum)obj);
        }
        if (List.class.isAssignableFrom(clazz) && this.isList(obj)) {
            Class subClazz = this.getClassAtDepth(field.getGenericType(), depth + 1);
            if (ConfigObject.class.isAssignableFrom(subClazz) || Map.class.isAssignableFrom(subClazz) || List.class.isAssignableFrom(subClazz) || subClazz.isEnum()) {
                return this.getList((List)obj, field, cs, path, depth);
            }
            return obj;
        }
        return obj;
    }

    protected Class getClassAtDepth(Type type, int depth) throws Exception {
        if (depth <= 0) {
            String className = type.toString();
            if (className.length() >= 6 && className.substring(0, 6).equalsIgnoreCase("class ")) {
                className = className.substring(6);
            }
            if (className.indexOf("<") >= 0) {
                className = className.substring(0, className.indexOf("<"));
            }
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                if (className.equalsIgnoreCase("byte")) {
                    return Byte.class;
                }
                if (className.equalsIgnoreCase("short")) {
                    return Short.class;
                }
                if (className.equalsIgnoreCase("int")) {
                    return Integer.class;
                }
                if (className.equalsIgnoreCase("long")) {
                    return Long.class;
                }
                if (className.equalsIgnoreCase("float")) {
                    return Float.class;
                }
                if (className.equalsIgnoreCase("double")) {
                    return Double.class;
                }
                if (className.equalsIgnoreCase("char")) {
                    return Character.class;
                }
                if (className.equalsIgnoreCase("boolean")) {
                    return Boolean.class;
                }
                throw ex;
            }
        }
        ParameterizedType pType = (ParameterizedType)type;
        Type[] typeArgs = pType.getActualTypeArguments();
        return this.getClassAtDepth(typeArgs[typeArgs.length - 1], --depth);
    }

    protected boolean isString(Object obj) {
        return obj instanceof String;
    }

    protected boolean isConfigurationSection(Object o) {
        try {
            return (ConfigurationSection)o != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isConfigObject(Object obj) {
        try {
            return (ConfigObject)obj != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isMultimap(Object obj) {
        try {
            return (Multimap)obj != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isTable(Object obj) {
        try {
            return (Table)obj != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isMap(Object obj) {
        try {
            return (Map)obj != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isList(Object obj) {
        try {
            return (List)obj != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isEnum(Class clazz, Object obj) {
        if (!clazz.isEnum()) {
            return false;
        }
        T[] TArray = clazz.getEnumConstants();
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object constant = TArray[n2];
            if (constant.equals(obj)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected ConfigObject getConfigObject(Class clazz, ConfigurationSection cs) throws Exception {
        ConfigObject obj = (ConfigObject)clazz.newInstance();
        obj.onLoad(cs);
        return obj;
    }

    protected Multimap getMultimap(Field field, ConfigurationSection cs, String path, int depth) throws Exception {
        ++depth;
        Set<String> keys = cs.getKeys(false);
        ArrayListMultimap multimap = ArrayListMultimap.create();
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                Object in = cs.get(key);
                in = this.loadObject(field, cs, key, depth);
                if (in instanceof List) {
                    multimap.putAll((Object)key, (Iterable)((List)in));
                    continue;
                }
                throw new InvalidConfigurationException(String.valueOf(cs.getCurrentPath()) + "." + key + " is not a List.");
            }
        }
        return multimap;
    }

    protected Table getTable(Field field, ConfigurationSection cs, String path, int depth) throws Exception {
        ++depth;
        Set<String> keys = cs.getKeys(false);
        HashBasedTable table = HashBasedTable.create();
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                Object in = cs.get(key);
                in = this.loadObject(field, cs, key, depth);
                if (in instanceof Map) {
                    Map map = (Map)in;
                    for (Map.Entry entry : map.entrySet()) {
                        table.put((Object)key, entry.getKey(), entry.getValue());
                    }
                    continue;
                }
                throw new InvalidConfigurationException(String.valueOf(cs.getCurrentPath()) + "." + key + " is not a Map.");
            }
        }
        return table;
    }

    protected Map getMap(Field field, ConfigurationSection cs, String path, int depth) throws Exception {
        ++depth;
        Set<String> keys = cs.getKeys(false);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                Object in = cs.get(key);
                in = this.loadObject(field, cs, key, depth);
                map.put(key, in);
            }
        }
        return map;
    }

    protected List getList(Field field, ConfigurationSection cs, String path, int depth) throws Exception {
        ++depth;
        int listSize = cs.getKeys(false).size();
        String key = path;
        if (key.lastIndexOf(".") >= 0) {
            key = key.substring(key.lastIndexOf("."));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (listSize > 0) {
            int loaded = 0;
            int i = 0;
            while (loaded < listSize) {
                if (cs.isSet(String.valueOf(key) + i)) {
                    Object in = cs.get(String.valueOf(key) + i);
                    in = this.loadObject(field, cs, String.valueOf(key) + i, depth);
                    list.add(in);
                    ++loaded;
                }
                if (++i <= listSize * 3) continue;
                loaded = listSize;
            }
        }
        return list;
    }

    protected Enum getEnum(Class clazz, String string) throws Exception {
        if (!clazz.isEnum()) {
            throw new Exception("Class " + clazz.getName() + " is not an enum.");
        }
        T[] TArray = clazz.getEnumConstants();
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object constant = TArray[n2];
            if (((Enum)constant).toString().equals(string)) {
                return (Enum)constant;
            }
            ++n2;
        }
        throw new Exception("String " + string + " not a valid enum constant for " + clazz.getName());
    }

    protected ConfigurationSection getConfigObject(ConfigObject obj, String path, ConfigurationSection cs) throws Exception {
        ConfigurationSection subCS = cs.createSection(path);
        obj.onSave(subCS);
        return subCS;
    }

    protected ConfigurationSection getMultimap(Multimap map, Field field, ConfigurationSection cs, String path, int depth) throws Exception {
        ++depth;
        ConfigurationSection subCS = cs.createSection(path);
        Set keys = map.keySet();
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                Object out = map.get((Object)key);
                out = this.saveObject(out, field, cs, String.valueOf(path) + "." + key, depth);
                subCS.set(key, out);
            }
        }
        return subCS;
    }

    protected ConfigurationSection getTable(Table table, Field field, ConfigurationSection cs, String path, int depth) throws Exception {
        ++depth;
        ConfigurationSection subCS = cs.createSection(path);
        Set keys = table.cellSet();
        if (keys != null && keys.size() > 0) {
            for (Table.Cell key : keys) {
                Object out = table.get(key.getRowKey(), key.getColumnKey());
                out = this.saveObject(out, field, cs, String.valueOf(path) + "." + key.getRowKey() + "." + key.getColumnKey(), depth);
                subCS.set(key.getRowKey() + "." + key.getColumnKey(), out);
            }
        }
        return subCS;
    }

    protected ConfigurationSection getMap(Map map, Field field, ConfigurationSection cs, String path, int depth) throws Exception {
        ++depth;
        ConfigurationSection subCS = cs.createSection(path);
        Set keys = map.keySet();
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                Object out = map.get(key);
                out = this.saveObject(out, field, cs, String.valueOf(path) + "." + key, depth);
                subCS.set(key, out);
            }
        }
        return subCS;
    }

    protected ConfigurationSection getList(List list, Field field, ConfigurationSection cs, String path, int depth) throws Exception {
        ++depth;
        ConfigurationSection subCS = cs.createSection(path);
        String key = path;
        if (key.lastIndexOf(".") >= 0) {
            key = key.substring(key.lastIndexOf("."));
        }
        if (list != null && list.size() > 0) {
            int i = 0;
            while (i < list.size()) {
                Object out = list.get(i);
                out = this.saveObject(out, field, cs, String.valueOf(path) + "." + key + (i + 1), depth);
                subCS.set(String.valueOf(key) + (i + 1), out);
                ++i;
            }
        }
        return subCS;
    }

    protected String getEnum(Enum enumObj) {
        return enumObj.toString();
    }

    protected boolean doSkip(Field field) {
        return Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || !Modifier.isPublic(field.getModifiers());
    }
}

