/*
 * Decompiled with CFR 0.152.
 */
package net.craftminecraft.bungee.bungeeyaml.supereasyconfig;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import net.craftminecraft.bungee.bungeeyaml.bukkitapi.InvalidConfigurationException;
import net.craftminecraft.bungee.bungeeyaml.bukkitapi.file.YamlConfiguration;
import net.craftminecraft.bungee.bungeeyaml.supereasyconfig.ConfigObject;

public abstract class Config
extends ConfigObject {
    protected transient File CONFIG_FILE = null;
    protected transient String CONFIG_HEADER = null;

    public Config load(File file) throws InvalidConfigurationException {
        if (file == null) {
            throw new InvalidConfigurationException(new NullPointerException());
        }
        if (!file.exists()) {
            throw new InvalidConfigurationException(new IOException("File doesn't exist"));
        }
        this.CONFIG_FILE = file;
        return this.reload();
    }

    public Config reload() throws InvalidConfigurationException {
        if (this.CONFIG_FILE == null) {
            throw new InvalidConfigurationException(new NullPointerException());
        }
        if (!this.CONFIG_FILE.exists()) {
            throw new InvalidConfigurationException(new IOException("File doesn't exist"));
        }
        YamlConfiguration yamlConfig = YamlConfiguration.loadConfiguration(this.CONFIG_FILE);
        try {
            this.onLoad(yamlConfig);
            yamlConfig.save(this.CONFIG_FILE);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException(ex);
        }
        return this;
    }

    public Config save(File file) throws InvalidConfigurationException {
        if (file == null) {
            throw new InvalidConfigurationException(new NullPointerException());
        }
        this.CONFIG_FILE = file;
        return this.save();
    }

    public Config save() throws InvalidConfigurationException {
        if (this.CONFIG_FILE == null) {
            throw new InvalidConfigurationException(new NullPointerException());
        }
        if (!this.CONFIG_FILE.exists()) {
            try {
                if (this.CONFIG_FILE.getParentFile() != null) {
                    this.CONFIG_FILE.getParentFile().mkdirs();
                }
                this.CONFIG_FILE.createNewFile();
                if (this.CONFIG_HEADER != null) {
                    BufferedWriter newConfig = new BufferedWriter(new FileWriter(this.CONFIG_FILE));
                    boolean firstLine = true;
                    String[] stringArray = this.CONFIG_HEADER.split("\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        if (!firstLine) {
                            newConfig.write("\n");
                        } else {
                            firstLine = false;
                        }
                        newConfig.write("# " + line);
                        ++n2;
                    }
                    ((Writer)newConfig).close();
                }
            }
            catch (Exception ex) {
                throw new InvalidConfigurationException(ex);
            }
        }
        YamlConfiguration yamlConfig = YamlConfiguration.loadConfiguration(this.CONFIG_FILE);
        try {
            this.onSave(yamlConfig);
            yamlConfig.save(this.CONFIG_FILE);
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException(ex);
        }
        return this;
    }

    public Config init(File file) throws InvalidConfigurationException {
        if (file == null) {
            throw new InvalidConfigurationException(new NullPointerException());
        }
        this.CONFIG_FILE = file;
        return this.init();
    }

    public Config init() throws InvalidConfigurationException {
        if (this.CONFIG_FILE == null) {
            throw new InvalidConfigurationException(new NullPointerException());
        }
        if (this.CONFIG_FILE.exists()) {
            return this.reload();
        }
        return this.save();
    }
}

